// DFGadget.cpp
//
// wrapper class for interface protocol of BeBar
//
// Copyright 1997 Thorsten Seitz

#include "DFGadget.h"
#include "StLocker.h"


const float cOffsetX = 2.0;
const float cOffsetY = 2.0;


// class DFMenuThread

long
DFMenuThread::Execute()
{
	BPopUpMenu *menu;
	{
		StLocker<DFGadget> lock(fGadget);
		
		if (fGadget->fMenuRunning) return B_ERROR;
		
		menu = fGadget->fPopUpMenu;
		fGadget->fMenuRunning = TRUE;
	}
	
	if (menu)
		menu->Go(fWhere, TRUE, TRUE, fSticky);
		
	{
		StLocker<DFGadget> lock(fGadget);
		fGadget->fMenuRunning = FALSE;
		
		BMessage *message = new BMessage('_AMN');
		fGadget->SendMessage(message, TRUE);
	}
	
	return B_NO_ERROR;
}


// class DFGadget

#pragma mark ## GADGET

DFGadget::DFGadget(float smallWidth, float largeWidth)

	: fID(0), 
	fSmallWidth(smallWidth), fLargeWidth(largeWidth),
	fSmallOffset(BPoint(cOffsetX, cOffsetY)), 
	fLargeOffset(BPoint(cOffsetX, cOffsetY)),
	fSmallIcon(NULL), fLargeIcon(NULL), 
	fPopUpMenu(NULL),
	fBar(new BMessenger('?BAR')), fGadget(NULL),
	fMenuRunning(FALSE)
{
	be_app->AddHandler(this);
	fGadget = new BMessenger(this);
}


DFGadget::~DFGadget()
{
	StLocker<DFGadget> lock(this);
	
	// remove gadget from BeBar
	
	BMessage *msg = new BMessage(DF_REMOVE_GADGET);
	
	if (msg) {
		msg->AddLong("client", be_app->Team());
		msg->AddLong("id", fID);
	
		if (fBar && fBar->IsValid())	
			fBar->SendMessage(msg);
	}
	delete fBar;

	StLocker<BLooper> looperLock(Looper());
	be_app->RemoveHandler(this);
	delete fGadget;
	
	delete fSmallIcon;
	delete fLargeIcon;
}


void
DFGadget::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
	
	case DF_SHOW_GADGET_MENU:
		
		DFMenuThread *thread =
			new DFMenuThread(this, msg->FindPoint("where"), 
								msg->FindRect("sticky"));
		if (thread) thread->Run();
		break;
		
	default:
		inherited::MessageReceived(msg);
		break;
	}
}


void
DFGadget::SetOffset(BPoint small, BPoint large)
{
	StLocker<DFGadget> 	lock(this);

	fSmallOffset = small; // offset at which the small icon is drawn
	fLargeOffset = large; // offset at which the large icon is drawn
	
	return;
}


void
DFGadget::SetBitmap(BBitmap *small, BBitmap *large)
{
	StLocker<DFGadget> 	lock(this);

	fSmallIcon = small; // this is drawn when the BeBar is small
	fLargeIcon = large; // this is drawn when the BeBar is large
	
	return;
}


long
DFGadget::SetGadgetMenu(BPopUpMenu *menu)
{
	StLocker<DFGadget> 	lock(this);

	fPopUpMenu = menu;

	return RegisterMenu();
}


long
DFGadget::RegisterMenu()
{
	StLocker<DFGadget> 	lock(this);

	BMessage *msg = new BMessage(DF_REGISTER_GADGET_MENU);
	
	if (msg) {
		msg->AddLong("client", be_app->Team());
		msg->AddLong("id", fID);
	
		msg->AddBool("menu", fPopUpMenu != NULL);
		msg->AddMessenger("target", *fGadget);
	}
	
	return SendMessage(msg);
}


long
DFGadget::Update(bool invalidate)
{
	BMessage 			*msg, *reply;
	BRect				bounds;
	StLocker<DFGadget> 	lock(this);
	
	if (fID == 0) {
		if (Connect() != B_NO_ERROR)
			return B_ERROR;
	}
		
	msg = new BMessage(DF_SET_BITMAP);
	
	if (msg) {
	
		msg->AddLong("client", be_app->Team());
		msg->AddLong("id", fID);
	
		if (fSmallIcon) {
			msg->AddData("bitmap", B_COLOR_8_BIT_TYPE, 
						fSmallIcon->Bits(), fSmallIcon->BitsLength());
	
			bounds = fSmallIcon->Bounds();
			bounds.OffsetTo(fSmallOffset);
			msg->AddRect("bounds", bounds);

			if (fLargeIcon) {
				msg->AddData("bitmap", B_COLOR_8_BIT_TYPE, 
						fLargeIcon->Bits(), fLargeIcon->BitsLength());

				bounds = fLargeIcon->Bounds();
			}
			
			bounds.OffsetTo(fLargeOffset);
			msg->AddRect("bounds", bounds);
		}
	

		if (invalidate)
			msg->AddBool("invalidate", TRUE);
	}
		
	return SendMessage(msg);
}


long
DFGadget::Connect()
{
	StLocker<DFGadget> 	lock(this);

	fID = 0; // fID > 0 represents a valid gadget
	delete fBar;
	fBar = new BMessenger('?BAR');

	if (fBar && fBar->Error() == B_NO_ERROR) { // connection ok?

		// request gadget of given width
		
		BMessage *msg = new BMessage(DF_REQUEST_GADGET);
		
		if (msg) {
			msg->AddLong("client", be_app->Team());
			msg->AddFloat("width", fSmallWidth);
			msg->AddFloat("width", fLargeWidth);
		
			BMessage *reply;
			fBar->SendMessage(msg, &reply);
		
			if (reply && reply->what == DF_GADGET_ID) { // request succesful?
			
				fID = reply->FindLong("id");
			
				if (fPopUpMenu) RegisterMenu();
			}
		
			delete reply;
		}
	}
	
	return fID ? B_NO_ERROR : B_ERROR;
}


long
DFGadget::SendMessage(BMessage *msg, bool async)
{
	long				result;
	StLocker<DFGadget> 	lock(this);

	if (msg == NULL) return B_ERROR;
	
	if (!(fBar && fBar->IsValid())) { // try to reconnect
		if (Connect() != B_NO_ERROR) {
			delete msg;
			return B_ERROR;
		}
	}

	BMessage *reply = NULL;
	if (async)
		fBar->SendMessage(msg);
	else
		fBar->SendMessage(msg, &reply);
	
	if (!reply || reply->what == DF_ERROR)
		result = B_ERROR;
	else
		result = B_NO_ERROR;
		
	delete reply;
	
	return result;
}
	
	